/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class TIMING_ProfileReference
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Network Timing Profile Reference";
    public static final String fullTypeInfo = "Network Timing Profile Reference".concat(" (1)");
    private int itsReference;

    public TIMING_ProfileReference(TLV parent, int ref) throws Exception {
        super(parent);
        this.setType(1);
        this.setNumber(ref);
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Profile Reference:");
    }

    @Override
    public int getNumber() {
        return this.itsReference;
    }

    private void checkConstraints(int number) throws InvalidNumberException {
        if (number < 1 || number > 65536) {
            throw new InvalidNumberException(this, 1, 65536);
        }
    }

    @Override
    public void setNumber(int number) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(number);
        }
        this.setData(this.encodeInt2(number));
        this.itsReference = number;
    }
}

