/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class V3NOT_UDPPort
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "UDP Port number of trap receiver";
    public static final String fullTypeInfo = "UDP Port number of trap receiver".concat(" (2)");
    private int itsPort = 0;

    public V3NOT_UDPPort(TLV parent, int port) throws Exception {
        super(parent);
        this.setType(2);
        this.setNumber(port);
    }

    private void checkConstraints(int port) throws InvalidNumberException {
        if (port < 1) {
            throw new InvalidNumberException(this, 1, 65535);
        }
        if (port > 65535) {
            throw new InvalidNumberException(this, 1, 65535);
        }
    }

    @Override
    public void setNumber(int port) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(port);
        this.setData(this.encodeInt2(port));
        this.itsPort = port;
    }

    @Override
    public int getNumber() {
        return this.itsPort;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsPort;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "UDP Port:");
    }
}

