/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types.docsis30;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTyped_SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub2types.docsis30.MESP_BP_ColorMarking;
import com.excentis.security.configfile.tlvs.tlvsub2types.docsis30.MESP_BP_ColorMode;
import com.excentis.security.configfile.tlvs.tlvsub2types.docsis30.MESP_BP_CommittedBurstSize;
import com.excentis.security.configfile.tlvs.tlvsub2types.docsis30.MESP_BP_CommittedInformationRate;
import com.excentis.security.configfile.tlvs.tlvsub2types.docsis30.MESP_BP_CouplingFlag;
import com.excentis.security.configfile.tlvs.tlvsub2types.docsis30.MESP_BP_ExcessBurstSize;
import com.excentis.security.configfile.tlvs.tlvsub2types.docsis30.MESP_BP_ExcessInformationRate;
import java.util.ArrayList;

public class MESP_BandwidthProfile
extends SubTyped_SubTLV {
    public static final int COMMITTED_INFORMATION_RATE = 1;
    public static final int COMMITTED_BURST_SIZE = 2;
    public static final int EXCESS_INFORMATION_RATE = 3;
    public static final int EXCESS_BURST_SIZE = 4;
    public static final int COUPLING_FLAG = 5;
    public static final int COLOR_MODE = 6;
    public static final int COLOR_MARKING = 7;
    public static final String typeInfo = "MESP Bandwidth Profile (MESP-BP)";
    public static final String fullTypeInfo = "MESP Bandwidth Profile (MESP-BP)".concat(" (2)");

    public MESP_BandwidthProfile(TLV parent, ArrayList<ISubTLV> subTLVs) throws Exception {
        super(parent);
        this.setType(2);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public MESP_BandwidthProfile(TLV parent, byte[] encodedSubTypes) throws Exception {
        super(parent);
        int length;
        this.setType(2);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new MESP_BP_CommittedInformationRate(this, this.getLongFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new MESP_BP_CommittedBurstSize(this, this.getLongFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new MESP_BP_ExcessInformationRate(this, this.getLongFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new MESP_BP_ExcessBurstSize(this, this.getLongFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 5) {
                sub = new MESP_BP_CouplingFlag(this, this.getBooleanFromBytes(value));
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 6) {
                sub = new MESP_BP_ColorMode((TLV)this, value);
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 7) {
                sub = new MESP_BP_ColorMarking((TLV)this, value);
                sub.setParent(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

