/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types.docsis30;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import com.excentis.security.configfile.tlvs.TLV_MESP;
import javax.swing.JPanel;

public class MESP_Reference
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "MESP Reference";
    public static final String fullTypeInfo = "MESP Reference".concat(" (1)");
    private int itsReference = -1;

    public MESP_Reference(TLV parent, int reference) throws Exception {
        super(parent);
        this.setType(1);
        this.setReference(reference);
    }

    private void checkConstraints(int reference) throws InvalidNumberException {
        if (reference < 1) {
            throw new InvalidNumberException(this, 1, 65535);
        }
        if (reference > 65535) {
            throw new InvalidNumberException(this, 1, 65535);
        }
        boolean[] qos = new boolean[]{true, true, true};
        boolean available = false;
        try {
            available = ((TLV_MESP)this.getParent()).getConfigFile().checkUsedRef(reference, qos, false);
        }
        catch (Exception e) {
            throw new InvalidNumberException(this, "Can't assign ref " + reference + ":" + e.getMessage());
        }
        if (!available) {
            throw new InvalidNumberException(this, "MESP Reference " + reference + " in use by other service flow.");
        }
    }

    public void setReference(int ref) throws InvalidNumberException, InvalidLengthException {
        if (ref == this.itsReference) {
            return;
        }
        int oldref = this.itsReference;
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(ref);
        }
        this.setData(this.encodeInt2(ref));
        this.itsReference = ref;
        try {
            ((TLV_MESP)this.getParent()).getConfigFile().updateUsedRef(oldref);
            ((TLV_MESP)this.getParent()).getConfigFile().updateUsedRef(ref);
        }
        catch (Exception e) {
            throw new InvalidNumberException(this, "Error updating used references after assigning " + ref + ", please check references manually!");
        }
    }

    public int getReference() {
        return this.itsReference;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsReference;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, typeInfo);
    }

    @Override
    public int getNumber() {
        return this.getReference();
    }

    @Override
    public void setNumber(int number) throws InvalidNumberException, InvalidLengthException {
        this.setReference(number);
    }
}

