/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types.docsis30;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.interfaces.IStringTlv;
import com.excentis.security.configfile.panels.basic.StringPanel;
import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.tools.Plaintext2Binary;
import javax.swing.JPanel;

public class SNMPv3ACCESSVIEW_Mask
extends SubTLV
implements IStringTlv {
    public static final String typeInfo = "SNMPv3 Access View Mask";
    public static final String fullTypeInfo = "SNMPv3 Access View Mask".concat(" (3)");

    public SNMPv3ACCESSVIEW_Mask(TLV parent, byte[] mask) throws Exception {
        super(parent);
        this.setType(3);
        this.setMask(mask);
    }

    private void checkConstraints(byte[] mask) throws Exception {
        if (mask.length > 16) {
            throw new Exception("access view mask must be between 0 and 16 bytes long");
        }
    }

    public void setMask(byte[] mask) throws Exception {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(mask);
        }
        this.setData(mask);
    }

    @Override
    public void setStringValue(String maskstring) throws Exception {
        Plaintext2Binary p2b = new Plaintext2Binary(maskstring);
        this.setMask(p2b.getBytes());
    }

    @Override
    public String getStringValue() {
        return new Binary2Plaintext(this.getValue()).getHexRepresentation();
    }

    @Override
    public String getShowValue() {
        return "" + this.getStringValue();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new StringPanel(this, "SNMPv3 Access View Mask (hex): ");
    }
}

