/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types.docsis30;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.interfaces.IAddressTlv;
import com.excentis.security.configfile.panels.basic.Ipv4OrIpv6AddressPanel;
import com.excentis.security.tools.Binary2Plaintext;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import javax.swing.JPanel;

public class STATICMULTI_GroupEncoding
extends SubTLV
implements IAddressTlv {
    public static final String typeInfo = "Static Multicast Group Encoding";
    public static final String fullTypeInfo = "Static Multicast Group Encoding".concat(" (1)");

    public STATICMULTI_GroupEncoding(TLV parent, byte[] address) throws Exception {
        super(parent);
        this.setType(1);
        this.setAddress(address);
    }

    private void checkConstraints(byte[] value) throws Exception {
        if (value.length != 4 && value.length != 16) {
            throw new Exception("Address must be 4 (IPv4) or 16 (IPv6) bytes long.");
        }
    }

    @Override
    public void setAddress(byte[] value) throws Exception {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(value);
        }
        this.setData(value);
    }

    @Override
    public String getAddress() {
        return this.getShowValue();
    }

    @Override
    public String getShowValue() {
        try {
            if (this.getValue().length == 4) {
                return Inet4Address.getByAddress(this.getValue()).getHostAddress();
            }
            if (this.getValue().length == 16) {
                return Inet6Address.getByAddress(this.getValue()).getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return new Binary2Plaintext(this.getValue()).getHexRepresentation();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new Ipv4OrIpv6AddressPanel(this);
    }
}

