/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types.docsis30;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class UNI_Duplex
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "UNI Duplex";
    public static final String fullTypeInfo = "UNI Duplex".concat(" (5)");
    private int itsduplex;

    public UNI_Duplex(TLV parent, int duplex) throws Exception {
        super(parent);
        this.setType(5);
        this.setNumber(duplex);
    }

    private void checkConstraints(int duplex) throws InvalidNumberException {
        if (duplex < 1) {
            throw new InvalidNumberException(this, 1, 2);
        }
        if (duplex > 2) {
            throw new InvalidNumberException(this, 1, 2);
        }
    }

    @Override
    public void setNumber(int duplex) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(duplex);
        }
        this.itsduplex = duplex;
        this.setData(this.encodeInt1(duplex));
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "UNI Duplex (1=half-duplex, 2=full-duplex):");
    }

    @Override
    public int getNumber() {
        return this.itsduplex;
    }
}

