/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types.docsis30;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class UNI_MediaType
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Media Type";
    public static final String fullTypeInfo = "Media Type".concat(" (9)");
    private int itsmediatype;

    public UNI_MediaType(TLV parent, int mediatype) throws Exception {
        super(parent);
        this.setType(9);
        this.setNumber(mediatype);
    }

    private void checkConstraints(int mediatype) throws InvalidNumberException {
        if (mediatype < 0) {
            throw new InvalidNumberException(this, 0, 1);
        }
        if (mediatype > 1) {
            throw new InvalidNumberException(this, 0, 1);
        }
    }

    @Override
    public void setNumber(int mediatype) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(mediatype);
        }
        this.itsmediatype = mediatype;
        this.setData(this.encodeInt1(mediatype));
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Media Type (0=SFP media, 1=BASE-T media):");
    }

    @Override
    public int getNumber() {
        return this.itsmediatype;
    }
}

