/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub1types.docsis30;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class UNI_OperatingSpeed
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "UNI Operating Speed";
    public static final String fullTypeInfo = "UNI Operating Speed".concat(" (4)");
    private int itsSpeed = -1;

    public UNI_OperatingSpeed(TLV parent, int speed) throws Exception {
        super(parent);
        this.setType(4);
        this.setNumber(speed);
    }

    private void checkConstraints(int speed) throws InvalidNumberException {
        if (speed < 1) {
            throw new InvalidNumberException(this, 1, 6);
        }
        if (speed > 6) {
            throw new InvalidNumberException(this, 1, 6);
        }
    }

    @Override
    public void setNumber(int speed) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(speed);
        }
        this.itsSpeed = speed;
        this.setData(this.encodeInt1(this.itsSpeed));
    }

    @Override
    public String getShowValue() {
        return "" + this.itsSpeed;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "UNI Operating Speed (check info for values):");
    }

    @Override
    public int getNumber() {
        return this.itsSpeed;
    }
}

