/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class AQM_ImmediateAQMMaxThreshold
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Immediate AQM Max Threshold";
    public static final String fullTypeInfo = "Immediate AQM Max Threshold".concat(" (4)");
    private int itsThreshold = 0;

    public AQM_ImmediateAQMMaxThreshold(TLV parent, int threshold) throws Exception {
        super(parent);
        this.setType(4);
        this.setNumber(threshold);
    }

    private void checkConstraints(int latency) throws InvalidNumberException {
        if (latency < 0) {
            throw new InvalidNumberException(this, 0, 65535);
        }
        if (latency > 65535) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public void setNumber(int threshold) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(threshold);
        this.setData(this.encodeInt2(threshold));
        this.itsThreshold = threshold;
    }

    @Override
    public int getNumber() {
        return this.itsThreshold;
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Maximum threshold of the ramp function (in microseconds):");
    }
}

