/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.interfaces.IMaskTlv;
import com.excentis.security.configfile.panels.basic.MaskPanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class AQM_LatencyHistogramEncodings
extends SubTLV
implements IMaskTlv {
    public static final String typeInfo = "Latency Histogram Encodings";
    public static final String fullTypeInfo = "Latency Histogram Encodings".concat(" (6)");

    public AQM_LatencyHistogramEncodings(TLV parent, byte[] histogram) throws Exception {
        super(parent);
        this.setType(6);
        this.setMask(histogram);
    }

    public void checkConstraints(byte[] histogram) throws Exception {
        if (histogram.length % 2 != 0) {
            throw new Exception("Histogram array must be of length 2N, Array of N bin edges (1 \u2264 N \u2264 15), got " + histogram.length + ")");
        }
        if (histogram.length > 30) {
            throw new Exception("Histogram array must be of length 2N, Array of N bin edges (1 \u2264 N \u2264 15), got " + histogram.length + ")");
        }
    }

    @Override
    public void setMask(byte[] vlan) throws InvalidLengthException {
        this.setData(vlan);
    }

    @Override
    public String getMask() {
        return new Binary2Plaintext(this.getValue()).getHexRepresentation();
    }

    @Override
    public String getShowValue() {
        return this.getMask();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new MaskPanel(this, "Array of N bin edges (1 \u2264 N \u2264 15): ");
    }
}

