/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class AQM_LatencyTarget
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Classic AQM Latency Target";
    public static final String fullTypeInfo = "Classic AQM Latency Target".concat(" (2)");
    private int itsLatency = 0;

    public AQM_LatencyTarget(TLV parent, int latency) throws Exception {
        super(parent);
        this.setType(2);
        this.setNumber(latency);
    }

    private void checkConstraints(int latency) throws InvalidNumberException {
        if (latency < 0) {
            throw new InvalidNumberException(this, 0, 255);
        }
        if (latency > 255) {
            throw new InvalidNumberException(this, 0, 255);
        }
    }

    @Override
    public void setNumber(int latency) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(latency);
        this.setData(this.encodeInt1(latency));
        this.itsLatency = latency;
    }

    @Override
    public int getNumber() {
        return this.itsLatency;
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "AQM Latency Target (ms):");
    }
}

