/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidLongNumberException;
import com.excentis.security.configfile.interfaces.ILongNumberTlv;
import com.excentis.security.configfile.panels.basic.LongNumberPanel;
import javax.swing.JPanel;

public class BufferControl_TargetBuffer
extends SubTLV
implements ILongNumberTlv {
    private long itsBuffer = 0L;
    public static final String typeInfo = "Target Buffer";
    public static final String fullTypeInfo = "Target Buffer".concat(" (2)");

    public BufferControl_TargetBuffer(TLV parent, long buffer) throws Exception {
        super(parent);
        this.setType(2);
        this.setLongNumber(buffer);
    }

    private void checkConstraints(long buffer) throws InvalidLongNumberException {
        if (buffer < 0L) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
        if (buffer > 0xFFFFFFFFL) {
            throw new InvalidLongNumberException(this, 0L, 0xFFFFFFFFL);
        }
    }

    @Override
    public void setLongNumber(long buffer) throws InvalidLongNumberException, InvalidLengthException {
        this.checkConstraints(buffer);
        this.setData(this.encodeLong(buffer));
        this.itsBuffer = buffer;
    }

    @Override
    public long getLongNumber() {
        return this.itsBuffer;
    }

    @Override
    public String getShowValue() {
        return "" + this.getLongNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new LongNumberPanel(this, "Buffer:");
    }
}

