/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.interfaces.IMaskTlv;
import com.excentis.security.configfile.panels.BasicTLVPanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class CM_SOFT_DL_OSCPResponse
extends SubTLV
implements IMaskTlv {
    public static final String typeInfo = "Online Certificate Status Responses for CVC Validation";
    public static final String fullTypeInfo = "Online Certificate Status Responses for CVC Validation".concat(" (1)");

    public CM_SOFT_DL_OSCPResponse(TLV parent, byte[] value) throws Exception {
        super(parent);
        this.setType(1);
        this.setMask(value);
    }

    private void checkConstraints(byte[] mask) throws InvalidLengthException {
        if (mask.length > 65533) {
            throw new InvalidLengthException("Online Certificate Status Responses for CVC Validation (limited to 65533 bytes)");
        }
    }

    @Override
    public void setMask(byte[] mask) throws Exception {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(mask);
        }
        this.setData(mask);
    }

    @Override
    public String getMask() {
        Binary2Plaintext b2p = new Binary2Plaintext(this.getValue());
        return "" + b2p.getHexRepresentation();
    }

    @Override
    public String getShowValue() {
        return this.getMask();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new BasicTLVPanel(this);
    }
}

