/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.interfaces.IStringTlv;
import com.excentis.security.configfile.panels.basic.StringPanel;
import java.util.regex.Pattern;
import javax.swing.JPanel;

public class COMMON_SSH_CFS_SSHSourceAddressRestrictions
extends SubTLV
implements IStringTlv {
    public static final String typeInfo = "SSH Source Address Restrictions";
    public static final String fullTypeInfo = "SSH Source Address Restrictions".concat(" (4)");
    private String ip_and_prefix;

    public COMMON_SSH_CFS_SSHSourceAddressRestrictions(TLV parent, String ip_and_prefix) throws Exception {
        super(parent);
        this.setType(4);
        this.setStringValue(ip_and_prefix);
    }

    private void checkConstraints(String ip_and_prefix) throws Exception {
        Pattern p = Pattern.compile("/|-");
        String[] parts = p.split(ip_and_prefix, 2);
        int prefix = new Integer(parts[1]);
        if (prefix < 0 || prefix > 128) {
            throw new Exception("prefix must be between 0 and 128, use ipv4/prefix or ipv6/prefix");
        }
    }

    @Override
    public void setStringValue(String ip_and_prefix) throws Exception {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(ip_and_prefix);
        }
        this.ip_and_prefix = ip_and_prefix;
        this.setData(ip_and_prefix.getBytes());
    }

    @Override
    public String getStringValue() {
        return this.ip_and_prefix;
    }

    @Override
    public String getShowValue() {
        return this.getStringValue();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new StringPanel(this, "Network/address specifier (in CIDR notation): ");
    }
}

