/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.panels.sub2panels.DownFreqRange_StepPanel;
import javax.swing.JPanel;

public class DownFreqRange_Step
extends SubTLV {
    public static final String typeInfo = "Downstream Frequency Range Step Size";
    public static final String fullTypeInfo = "Downstream Frequency Range Step Size".concat(" (4)");
    private int itsFrequency = 0;

    public DownFreqRange_Step(TLV parent, int frequency) throws Exception {
        super(parent);
        this.setType(4);
        this.setFrequency(frequency);
    }

    private void checkConstraints(int channel) throws Exception {
        if (channel % 62500 != 0) {
            throw new Exception("frequency step must be a multiple of 62500 Hz.\n");
        }
    }

    public void setFrequency(int freq) throws Exception {
        this.checkConstraints(freq);
        this.setData(this.encodeInt4(freq));
        this.itsFrequency = freq;
    }

    public int getIntValue() {
        return this.itsFrequency;
    }

    @Override
    public String getShowValue() {
        return "" + this.getIntValue();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new DownFreqRange_StepPanel(this);
    }
}

