/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class EHQOS_SFPriority
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Constituent SF Priority";
    public static final String fullTypeInfo = "Constituent SF Priority".concat(" (4)");
    private int itsPriority = 0;

    public EHQOS_SFPriority(TLV parent, int priority) throws Exception {
        super(parent);
        this.setType(4);
        this.setNumber(priority);
    }

    private void checkConstraints(int reference) throws InvalidNumberException {
        if (reference < 0) {
            throw new InvalidNumberException(this, 0, 7);
        }
        if (reference > 7) {
            throw new InvalidNumberException(this, 0, 7);
        }
    }

    @Override
    public void setNumber(int priority) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(priority);
        }
        this.setData(this.encodeInt1(priority));
        this.itsPriority = priority;
    }

    @Override
    public int getNumber() {
        return this.itsPriority;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsPriority;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Traffic Priority:");
    }
}

