/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class EHQOS_SFWeight
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Constituent SF Weight";
    public static final String fullTypeInfo = "Constituent SF Weight".concat(" (5)");
    private int itsWeight = 0;

    public EHQOS_SFWeight(TLV parent, int weight) throws Exception {
        super(parent);
        this.setType(5);
        this.setNumber(weight);
    }

    private void checkConstraints(int weight) throws InvalidNumberException {
        if (weight < 1) {
            throw new InvalidNumberException(this, 1, 255);
        }
        if (weight > 255) {
            throw new InvalidNumberException(this, 1, 255);
        }
    }

    @Override
    public void setNumber(int weight) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(weight);
        }
        this.setData(this.encodeInt1(weight));
        this.itsWeight = weight;
    }

    @Override
    public int getNumber() {
        return this.itsWeight;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsWeight;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Constituent SF Weight:");
    }
}

