/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.panels.sub2panels.ETH_DestinationMACPanel;
import com.excentis.security.tools.Plaintext2Binary;
import com.excentis.security.utils.CertUtils;
import javax.swing.JPanel;

public class ETH_DestinationMAC
extends SubTLV {
    public static final String typeInfo = "Destination MAC Address";
    public static final String fullTypeInfo = "Destination MAC Address".concat(" (1)");
    private String itsMac = null;
    private String itsMask = null;

    public ETH_DestinationMAC(TLV parent, String s, String mask) throws Exception {
        super(parent);
        int i;
        if (s.length() != 12) {
            throw new Exception("Mac address should contain exactly 12 characters (6 bytes).");
        }
        for (i = 0; i < s.length(); ++i) {
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9' || 'A' <= s.charAt(i) && s.charAt(i) <= 'F' || 'a' <= s.charAt(i) && s.charAt(i) <= 'f') continue;
            throw new Exception("Invalid hexadecimal character detected.");
        }
        this.itsMac = s;
        if (mask.length() != 12) {
            throw new Exception("Mask should contain exactly 12 characters (6 bytes).");
        }
        for (i = 0; i < mask.length(); ++i) {
            if ('0' <= mask.charAt(i) && mask.charAt(i) <= '9' || 'A' <= mask.charAt(i) && mask.charAt(i) <= 'F' || 'a' <= mask.charAt(i) && mask.charAt(i) <= 'f') continue;
            throw new Exception("Invalid hexadecimal character detected.");
        }
        this.itsMask = mask;
        this.setType(1);
        this.setData(CertUtils.appendAt(new Plaintext2Binary(s).getBytes(), new Plaintext2Binary(mask).getBytes()));
    }

    public void setMac(String s) throws Exception {
        if (s.length() != 12) {
            throw new Exception("Mac address should contain exactly 12 characters (6 bytes).");
        }
        for (int i = 0; i < s.length(); ++i) {
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9' || 'A' <= s.charAt(i) && s.charAt(i) <= 'F' || 'a' <= s.charAt(i) && s.charAt(i) <= 'f') continue;
            throw new Exception("Invalid hexadecimal character detected.");
        }
        this.itsMac = s;
        this.setData(CertUtils.appendAt(new Plaintext2Binary(this.itsMac).getBytes(), new Plaintext2Binary(this.itsMask).getBytes()));
    }

    public void setMask(String s) throws Exception {
        if (s.length() != 12) {
            throw new Exception("Mask should contain exactly 12 characters (6 bytes).");
        }
        for (int i = 0; i < s.length(); ++i) {
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9' || 'A' <= s.charAt(i) && s.charAt(i) <= 'F' || 'a' <= s.charAt(i) && s.charAt(i) <= 'f') continue;
            throw new Exception("Invalid hexadecimal character detected.");
        }
        this.itsMask = s;
        this.setData(CertUtils.appendAt(new Plaintext2Binary(this.itsMac).getBytes(), new Plaintext2Binary(this.itsMask).getBytes()));
    }

    public String getMac() {
        return this.itsMac;
    }

    public String getMask() {
        return this.itsMask;
    }

    @Override
    public String getShowValue() {
        return "MAC " + this.itsMac + " MASK " + this.itsMask;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new ETH_DestinationMACPanel(this);
    }
}

