/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.panels.sub2panels.ETH_EthertypeDsapMacTypePanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class ETH_EthertypeDsapMacType
extends SubTLV {
    public static final String typeInfo = "Ethertype/DSAP/MacType";
    public static final String fullTypeInfo = "Ethertype/DSAP/MacType".concat(" (3)");
    private byte itsPType = 0;
    private byte itsProt1 = (byte)-1;
    private byte itsProt2 = (byte)-1;

    public ETH_EthertypeDsapMacType(TLV parent, byte typ, byte eprot1, byte eprot2) throws Exception {
        super(parent);
        this.setType(3);
        if (typ < 0 || typ > 4) {
            throw new Exception("Type must be between 0 and 4");
        }
        this.itsPType = typ;
        this.itsProt1 = eprot1;
        this.itsProt2 = eprot2;
        this.setData(new byte[]{this.itsPType, this.itsProt1, this.itsProt2});
    }

    public void setPType(byte typ) throws Exception {
        if (typ < 0 || typ > 4) {
            throw new Exception("Type must be between 0 and 4");
        }
        this.itsPType = typ;
        this.setData(new byte[]{this.itsPType, this.itsProt1, this.itsProt2});
    }

    public void setProt1(byte eprot1) throws InvalidLengthException {
        this.itsProt1 = eprot1;
        this.setData(new byte[]{this.itsPType, this.itsProt1, this.itsProt2});
    }

    public void setProt2(byte eprot2) throws InvalidLengthException {
        this.itsProt2 = eprot2;
        this.setData(new byte[]{this.itsPType, this.itsProt1, this.itsProt2});
    }

    public byte getPType() {
        return this.itsPType;
    }

    public byte getProt1() {
        return this.itsProt1;
    }

    public byte getProt2() {
        return this.itsProt2;
    }

    @Override
    public String getShowValue() {
        Binary2Plaintext b2p = new Binary2Plaintext(new byte[]{this.itsPType});
        Binary2Plaintext b2p2 = new Binary2Plaintext(new byte[]{this.itsProt1});
        Binary2Plaintext b2p3 = new Binary2Plaintext(new byte[]{this.itsProt2});
        return "type 0x" + b2p.getHexRepresentation() + " eprot1 0x" + b2p2.getHexRepresentation() + " eprot2 0x" + b2p3.getHexRepresentation();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new ETH_EthertypeDsapMacTypePanel(this);
    }
}

