/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.panels.sub2panels.ETH_SourceMACPanel;
import com.excentis.security.tools.Plaintext2Binary;
import javax.swing.JPanel;

public class ETH_SourceMAC
extends SubTLV {
    public static final String typeInfo = "Source MAC Address";
    public static final String fullTypeInfo = "Source MAC Address".concat(" (2)");
    private String itsMac = null;

    public ETH_SourceMAC(TLV parent, String s) throws Exception {
        super(parent);
        if (s.length() != 12) {
            throw new Exception("Mac address should contain exactly 12 characters (6 bytes).");
        }
        for (int i = 0; i < s.length(); ++i) {
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9' || 'A' <= s.charAt(i) && s.charAt(i) <= 'F' || 'a' <= s.charAt(i) && s.charAt(i) <= 'f') continue;
            throw new Exception("Invalid hexadecimal character detected.");
        }
        this.itsMac = s;
        this.setType(2);
        this.setData(new Plaintext2Binary(s).getBytes());
    }

    public void setMac(String s) throws Exception {
        if (s.length() != 12) {
            throw new Exception("Mac address should contain exactly 12 characters (6 bytes).");
        }
        for (int i = 0; i < s.length(); ++i) {
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9' || 'A' <= s.charAt(i) && s.charAt(i) <= 'F' || 'a' <= s.charAt(i) && s.charAt(i) <= 'f') continue;
            throw new Exception("Invalid hexadecimal character detected.");
        }
        this.itsMac = s;
        this.setData(new Plaintext2Binary(this.itsMac).getBytes());
    }

    public String getMac() {
        return this.itsMac;
    }

    @Override
    public String getShowValue() {
        return "MAC " + this.itsMac;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new ETH_SourceMACPanel(this);
    }
}

