/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.panels.sub2panels.IEEE_QVlanIdPanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class IEEE_QVlanId
extends SubTLV {
    public static final String typeInfo = "IEEE 802.1Q VLAN_ID";
    public static final String fullTypeInfo = "IEEE 802.1Q VLAN_ID".concat(" (2)");
    private byte[] itsID = null;

    public IEEE_QVlanId(TLV parent, byte[] value) throws Exception {
        super(parent);
        this.checkConstraints(value);
        this.setType(2);
        this.setData(value);
        this.itsID = (byte[])value.clone();
    }

    private void checkConstraints(byte[] value) throws Exception {
        if (value.length != 2) {
            throw new Exception("VLAN_ID length must be 2 bytes");
        }
    }

    public void setID(byte[] value) throws Exception {
        this.checkConstraints(value);
        this.setData(value);
    }

    @Override
    public String getShowValue() {
        Binary2Plaintext b2p = new Binary2Plaintext(this.itsID);
        return "" + b2p.getHexRepresentation();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new IEEE_QVlanIdPanel(this);
    }
}

