/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class IPMULTI_MaximumMulticastSessions
extends SubTLV
implements INumberTlv {
    private int numSessions = 65535;
    public static final String typeInfo = "Maximum Multicast Sessions";
    public static final String fullTypeInfo = "Maximum Multicast Sessions".concat(" (3)");

    public IPMULTI_MaximumMulticastSessions(TLV parent, int sessions) throws Exception {
        super(parent);
        this.setType(3);
        this.setNumber(sessions);
    }

    private void checkConstraints(int sessions) throws InvalidNumberException {
        if (sessions < 0 || sessions > 65535) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public void setNumber(int sessions) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(sessions);
        }
        this.numSessions = sessions;
        this.setData(this.encodeInt2(this.numSessions));
    }

    @Override
    public int getNumber() {
        return this.numSessions;
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Maximum Multicast Sessions:");
    }
}

