/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class IP_Protocol
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "IP Protocol";
    public static final String fullTypeInfo = "IP Protocol".concat(" (2)");
    private int itsProtocol = 0;

    public IP_Protocol(TLV parent, int Protocol) throws Exception {
        super(parent);
        this.setType(2);
        this.setNumber(Protocol);
    }

    private void checkConstraints(int Protocol) throws InvalidNumberException {
        if (Protocol < 0) {
            throw new InvalidNumberException(this, 0, 257);
        }
        if (Protocol > 257) {
            throw new InvalidNumberException(this, 0, 257);
        }
    }

    @Override
    public void setNumber(int Protocol) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(Protocol);
        this.setData(this.encodeInt2(Protocol));
        this.itsProtocol = Protocol;
    }

    @Override
    public int getNumber() {
        return this.itsProtocol;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsProtocol;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Protocol:");
    }
}

