/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class IP_TCPDestinationStart
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "TCP/UDP Destination Port Start";
    public static final String fullTypeInfo = "TCP/UDP Destination Port Start".concat(" (9)");
    private int itsPort = 0;

    public IP_TCPDestinationStart(TLV parent, int port) throws Exception {
        super(parent);
        this.setType(9);
        this.setNumber(port);
    }

    private void checkConstraints(int port) throws InvalidNumberException {
        if (port < 0) {
            throw new InvalidNumberException(this, 0, 65535);
        }
        if (port > 65535) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public void setNumber(int port) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(port);
        this.setData(this.encodeInt2(port));
        this.itsPort = port;
    }

    @Override
    public int getNumber() {
        return this.itsPort;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsPort;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "TCP/UDP port start:");
    }
}

