/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.panels.sub2panels.IP_ToSPanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class IP_ToS
extends SubTLV {
    public static final String typeInfo = "IP Type of Service Range and Mask";
    public static final String fullTypeInfo = "IP Type of Service Range and Mask".concat(" (1)");
    private byte itsTosLow = 0;
    private byte itsTosHigh = (byte)-1;
    private byte itsMask = (byte)-1;

    public IP_ToS(TLV parent, byte low, byte high, byte mask) throws Exception {
        super(parent);
        this.setType(1);
        this.setData(new byte[]{low, high, mask});
        this.itsTosLow = low;
        this.itsTosHigh = high;
        this.itsMask = mask;
    }

    public void setLow(byte low) throws InvalidLengthException {
        this.itsTosLow = low;
        this.setData(new byte[]{this.itsTosLow, this.itsTosHigh, this.itsMask});
    }

    public void setHigh(byte High) throws InvalidLengthException {
        this.itsTosHigh = High;
        this.setData(new byte[]{this.itsTosLow, this.itsTosHigh, this.itsMask});
    }

    public void setMask(byte Mask) throws InvalidLengthException {
        this.itsMask = Mask;
        this.setData(new byte[]{this.itsTosLow, this.itsTosHigh, this.itsMask});
    }

    public byte getMask() {
        return this.itsMask;
    }

    public byte getTosLow() {
        return this.itsTosLow;
    }

    public byte getTosHigh() {
        return this.itsTosHigh;
    }

    @Override
    public String getShowValue() {
        Binary2Plaintext b2p = new Binary2Plaintext(new byte[]{this.itsTosLow});
        Binary2Plaintext b2p2 = new Binary2Plaintext(new byte[]{this.itsTosHigh});
        Binary2Plaintext b2p3 = new Binary2Plaintext(new byte[]{this.itsMask});
        return "tos-low 0x" + b2p.getHexRepresentation() + " tos-high 0x" + b2p2.getHexRepresentation() + " tos-mask 0x" + b2p3.getHexRepresentation();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new IP_ToSPanel(this);
    }
}

