/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.interfaces.IIpv6Tlv;
import com.excentis.security.configfile.panels.basic.Ipv6AddressPanel;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JPanel;

public class IPv6_DestinationAddress
extends SubTLV
implements IIpv6Tlv {
    public static final String typeInfo = "IPv6 Destination Address";
    public static final String fullTypeInfo = "IPv6 Destination Address".concat(" (6)");

    public IPv6_DestinationAddress(TLV parent, Inet6Address address) throws Exception {
        super(parent);
        this.setType(6);
        this.setAddress(address);
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public String getShowValue() {
        return this.getAddress().getHostAddress();
    }

    @Override
    public JPanel showGUI() {
        return new Ipv6AddressPanel(this);
    }

    @Override
    public Inet6Address getAddress() {
        Inet6Address address = null;
        try {
            address = this.getIpv6AddressFromByte(this.getValue());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (InvalidLengthException e) {
            e.printStackTrace();
        }
        return address;
    }

    @Override
    public void setAddress(Inet6Address address) throws InvalidLengthException {
        this.setData(address.getAddress());
    }

    protected Inet6Address getIpv6AddressFromByte(byte[] bytes) throws InvalidLengthException, UnknownHostException {
        if (bytes.length != 16) {
            throw new InvalidLengthException(typeInfo);
        }
        return (Inet6Address)InetAddress.getByAddress(bytes);
    }
}

