/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.panels.sub2panels.IPv6_FlowLabelPanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class IPv6_FlowLabel
extends SubTLV {
    public static final String typeInfo = "IPv6 Flow Label";
    public static final String fullTypeInfo = "IPv6 Flow Label".concat(" (2)");

    public IPv6_FlowLabel(TLV parent, byte[] label) throws Exception {
        super(parent);
        this.setType(2);
        this.setLabel(label);
    }

    private void checkConstraints(byte[] label) throws Exception {
        if (label.length != 4) {
            throw new Exception("Flow Label must be 4 bytes long");
        }
    }

    public void setLabel(byte[] label) throws Exception {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(label);
        }
        this.setData(label);
    }

    public byte[] getLabel() {
        return this.getValue();
    }

    @Override
    public String getShowValue() {
        return "" + new Binary2Plaintext(this.getValue()).getHexRepresentation();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new IPv6_FlowLabelPanel(this);
    }
}

