/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.panels.sub2panels.IPv6_NextHeaderTypePanel;
import javax.swing.JPanel;

public class IPv6_NextHeaderType
extends SubTLV {
    public static final String typeInfo = "IPv6 Next Header Type";
    public static final String fullTypeInfo = "IPv6 Next Header Type".concat(" (3)");
    private int itsNextHeader = 0;

    public IPv6_NextHeaderType(TLV parent, int nextheader) throws Exception {
        super(parent);
        this.setType(3);
        this.setNextHeader(nextheader);
    }

    private void checkConstraints(int nextheader) throws Exception {
        if (nextheader < 0) {
            throw new Exception("Next Header type must be between 0 and 257");
        }
        if (nextheader > 257) {
            throw new Exception("Next Header type must be between 0 and 257");
        }
    }

    public void setNextHeader(int nextheader) throws Exception {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(nextheader);
        }
        this.setData(this.encodeInt2(nextheader));
        this.itsNextHeader = nextheader;
    }

    public int getNextHeader() {
        return this.itsNextHeader;
    }

    @Override
    public String getShowValue() {
        return "" + this.getNextHeader();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new IPv6_NextHeaderTypePanel(this);
    }
}

