/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.panels.sub2panels.IPv6_TrafficClassPanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class IPv6_TrafficClass
extends SubTLV {
    public static final String typeInfo = "IPv6 Traffic Class Range and Mask";
    public static final String fullTypeInfo = "IPv6 Traffic Class Range and Mask".concat(" (1)");
    private byte itsTcLow = 0;
    private byte itsTcHigh = (byte)-1;
    private byte itsMask = (byte)-1;

    public IPv6_TrafficClass(TLV parent, byte low, byte high, byte mask) throws Exception {
        super(parent);
        this.setType(1);
        this.setData(new byte[]{low, high, mask});
        this.itsTcLow = low;
        this.itsTcHigh = high;
        this.itsMask = mask;
    }

    public void setLow(byte low) throws InvalidLengthException {
        this.itsTcLow = low;
        this.setData(new byte[]{this.itsTcLow, this.itsTcHigh, this.itsMask});
    }

    public void setHigh(byte High) throws InvalidLengthException {
        this.itsTcHigh = High;
        this.setData(new byte[]{this.itsTcLow, this.itsTcHigh, this.itsMask});
    }

    public void setMask(byte Mask) throws InvalidLengthException {
        this.itsMask = Mask;
        this.setData(new byte[]{this.itsTcLow, this.itsTcHigh, this.itsMask});
    }

    public byte getMask() {
        return this.itsMask;
    }

    public byte getTcLow() {
        return this.itsTcLow;
    }

    public byte getTcHigh() {
        return this.itsTcHigh;
    }

    @Override
    public String getShowValue() {
        Binary2Plaintext b2p = new Binary2Plaintext(new byte[]{this.itsTcLow});
        Binary2Plaintext b2p2 = new Binary2Plaintext(new byte[]{this.itsTcHigh});
        Binary2Plaintext b2p3 = new Binary2Plaintext(new byte[]{this.itsMask});
        return "tc-low 0x" + b2p.getHexRepresentation() + " tc-high 0x" + b2p2.getHexRepresentation() + " tc-mask 0x" + b2p3.getHexRepresentation();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new IPv6_TrafficClassPanel(this);
    }
}

