/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTyped_SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub3types.BGP_CEID_VEID;
import com.excentis.security.configfile.tlvs.tlvsub3types.BGP_RouteDistinguisher;
import com.excentis.security.configfile.tlvs.tlvsub3types.BGP_RouteTargetImport;
import com.excentis.security.configfile.tlvs.tlvsub3types.BGP_VPNID;
import java.util.ArrayList;

public class L2VPN_BGPSubtype
extends SubTyped_SubTLV {
    public static final String typeInfo = "BGP Attribute sub TLV";
    public static final String fullTypeInfo = "BGP Attribute sub TLV".concat(" (21)");
    public static final int BGP_ID = 1;
    public static final int ROUTE_DISTINGUISHER = 2;
    public static final int ROUTE_TARGET_IMPORT = 3;
    public static final int ROUTE_TARGET_EXPORT = 4;
    public static final int CEID_VEID = 5;

    public L2VPN_BGPSubtype(TLV parent, ArrayList<ISubTLV> subTLVs) throws Exception {
        super(parent);
        this.setType(21);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public L2VPN_BGPSubtype(TLV parent, byte[] encodedSubTypes) throws Exception {
        super(parent);
        int length;
        this.setType(21);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new BGP_VPNID(this, this.getLongFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new BGP_RouteDistinguisher(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new BGP_RouteTargetImport(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new BGP_RouteTargetImport(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 5) {
                sub = new BGP_CEID_VEID(this, this.getIntFromBytes(value));
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

