/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ISubTLV;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.SubTyped_SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.UnsupportedTypeException;
import com.excentis.security.configfile.tlvs.tlvsub3types.L2VPN_NSI_Ieee8021ad;
import com.excentis.security.configfile.tlvs.tlvsub3types.L2VPN_NSI_Ieee8021ad_Stpid;
import com.excentis.security.configfile.tlvs.tlvsub3types.L2VPN_NSI_Ieee8021ah;
import com.excentis.security.configfile.tlvs.tlvsub3types.L2VPN_NSI_Ieee8021q;
import com.excentis.security.configfile.tlvs.tlvsub3types.L2VPN_NSI_L2TPv3Peer;
import com.excentis.security.configfile.tlvs.tlvsub3types.L2VPN_NSI_MplsPw;
import com.excentis.security.configfile.tlvs.tlvsub3types.L2VPN_NSI_Other;
import java.util.ArrayList;

public class L2VPN_NSIEncapsulationSubtype
extends SubTyped_SubTLV {
    public static final String typeInfo = "NSI Encapsulation Subtype";
    public static final String fullTypeInfo = "NSI Encapsulation Subtype".concat(" (2)");
    public static final int NSI_OTHER = 1;
    public static final int NSI_IEEE8021Q = 2;
    public static final int NSI_IEEE8021AD = 3;
    public static final int NSI_MPLS_PW = 4;
    public static final int NSI_L2TPV3PEER = 5;
    public static final int NSI_IEEE8021AH = 6;
    public static final int NSI_IEEE8021AD_STPID = 8;

    public L2VPN_NSIEncapsulationSubtype(TLV parent, ArrayList<ISubTLV> subTLVs) throws Exception {
        super(parent);
        this.setType(2);
        this.setSubTLVs(subTLVs);
        this.setData(this.encode(this.getSubTLVs()));
    }

    public L2VPN_NSIEncapsulationSubtype(TLV parent, byte[] encodedSubTypes) throws Exception {
        super(parent);
        int length;
        this.setType(2);
        int totalLength = encodedSubTypes.length;
        for (int pointer = 0; pointer < totalLength; pointer += length) {
            SubTLV sub;
            int type = this.getTypeFromByte(encodedSubTypes[pointer++]);
            length = this.getLengthFromByte(encodedSubTypes[pointer++]);
            byte[] value = this.getValueFromBytes(length, totalLength, pointer, type, encodedSubTypes);
            if (type == 1) {
                sub = new L2VPN_NSI_Other(this);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 2) {
                sub = new L2VPN_NSI_Ieee8021q(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 3) {
                sub = new L2VPN_NSI_Ieee8021ad(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 4) {
                sub = new L2VPN_NSI_MplsPw((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 5) {
                byte[] address = new byte[value.length - 1];
                System.arraycopy(value, 1, address, 0, address.length);
                L2VPN_NSI_L2TPv3Peer sub2 = new L2VPN_NSI_L2TPv3Peer(this, address);
                this.getSubTLVs().add(sub2);
                continue;
            }
            if (type == 6) {
                sub = new L2VPN_NSI_Ieee8021ah((TLV)this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            if (type == 8) {
                sub = new L2VPN_NSI_Ieee8021ad_Stpid(this, value);
                this.getSubTLVs().add(sub);
                continue;
            }
            throw new UnsupportedTypeException(typeInfo, type);
        }
        this.setSubTLVs(this.reArrange(this.getSubTLVs()));
        this.setData(this.encode(this.getSubTLVs()));
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }
}

