/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class L2VPN_PseudowireSignaling
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Pseudowire Signaling";
    public static final String fullTypeInfo = "Pseudowire Signaling".concat(" (23)");
    private int signum;

    public L2VPN_PseudowireSignaling(TLV parent, int signum) throws Exception {
        super(parent);
        this.setType(23);
        this.setNumber(signum);
    }

    private void checkConstraints(int signum) throws InvalidNumberException {
        if (!(ConfigFile.getCheatMode() || signum >= 0 && signum <= 2)) {
            throw new InvalidNumberException(this, 0, 2);
        }
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Pseudowire Signaling: ");
    }

    @Override
    public int getNumber() {
        return this.signum;
    }

    @Override
    public void setNumber(int number) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(number);
        }
        this.signum = number;
        this.setData(this.encodeInt1(this.signum));
    }
}

