/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.ILowHighTlv;
import com.excentis.security.configfile.panels.basic.LowHighPanel;
import javax.swing.JPanel;

public class L2VPN_UserPriorityRange
extends SubTLV
implements ILowHighTlv {
    public static final String typeInfo = "User Priority Range";
    public static final String fullTypeInfo = "User Priority Range".concat(" (9)");
    private int itsLow = 0;
    private int itsHigh = 0;

    public L2VPN_UserPriorityRange(TLV parent, int low, int high) throws Exception {
        super(parent);
        this.setType(9);
        this.setLow(low);
        this.setHigh(high);
    }

    private void checkConstraints(int pri) throws InvalidNumberException {
        if (!ConfigFile.getCheatMode()) {
            if (pri < 0) {
                throw new InvalidNumberException(this, 0, 7);
            }
            if (pri > 7) {
                throw new InvalidNumberException(this, 0, 7);
            }
        }
    }

    @Override
    public void setLow(int prio) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(prio);
        this.itsLow = prio;
        this.setData(this.encodeIntLowHigh(this.itsLow, this.itsHigh));
    }

    @Override
    public void setHigh(int prio) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(prio);
        this.itsHigh = prio;
        this.setData(this.encodeIntLowHigh(this.itsLow, this.itsHigh));
    }

    @Override
    public int getLow() {
        return this.itsLow;
    }

    @Override
    public int getHigh() {
        return this.itsHigh;
    }

    @Override
    public String getShowValue() {
        return "low " + this.itsLow + " high " + this.itsHigh;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new LowHighPanel(this);
    }
}

