/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class LL_QPDrainRateExponent
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "QPDrainRateExponent";
    public static final String fullTypeInfo = "QPDrainRateExponent".concat(" (10)");
    private int itsExponent = -1;

    public LL_QPDrainRateExponent(TLV parent, int exponent) throws Exception {
        super(parent);
        this.setType(10);
        this.setNumber(exponent);
    }

    private void checkConstraints(int exponent) throws InvalidNumberException {
        if (exponent < 0) {
            throw new InvalidNumberException(this, 0, 255);
        }
        if (exponent > 255) {
            throw new InvalidNumberException(this, 0, 255);
        }
    }

    @Override
    public String getShowValue() {
        return "" + this.itsExponent;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "QP Drain Rate Exponent:");
    }

    @Override
    public int getNumber() {
        return this.itsExponent;
    }

    @Override
    public void setNumber(int exponent) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(exponent);
        }
        this.setData(this.encodeInt1(exponent));
        this.itsExponent = exponent;
    }
}

