/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class LL_QPQueuingScoreThreshold
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "QPQueuingScoreThreshold";
    public static final String fullTypeInfo = "QPQueuingScoreThreshold".concat(" (9)");
    private int itsThreshold = -1;

    public LL_QPQueuingScoreThreshold(TLV parent, int threshold) throws Exception {
        super(parent);
        this.setType(9);
        this.setNumber(threshold);
    }

    private void checkConstraints(int threshold) throws InvalidNumberException {
        if (threshold < 0) {
            throw new InvalidNumberException(this, 0, 65535);
        }
        if (threshold > 65535) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public String getShowValue() {
        return "" + this.itsThreshold;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "QP Queuing Score Threshold:");
    }

    @Override
    public int getNumber() {
        return this.itsThreshold;
    }

    @Override
    public void setNumber(int threshold) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(threshold);
        }
        this.setData(this.encodeInt2(threshold));
        this.itsThreshold = threshold;
    }
}

