/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class LL_Reference
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Low Latency Service Flow Reference";
    public static final String fullTypeInfo = "Low Latency Service Flow Reference".concat(" (1)");
    private int itsReference = -1;

    public LL_Reference(TLV parent, int reference) throws Exception {
        super(parent);
        this.setType(1);
        this.setNumber(reference);
    }

    private void checkConstraints(int reference) throws InvalidNumberException {
        if (reference < 1) {
            throw new InvalidNumberException(this, 1, 65535);
        }
        if (reference > 65535) {
            throw new InvalidNumberException(this, 1, 65535);
        }
    }

    @Override
    public String getShowValue() {
        return "" + this.itsReference;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Low Latency Service Flow Reference:");
    }

    @Override
    public int getNumber() {
        return this.itsReference;
    }

    @Override
    public void setNumber(int ref) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(ref);
        }
        this.setData(this.encodeInt2(ref));
        this.itsReference = ref;
    }
}

