/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.interfaces.IStringTlv;
import com.excentis.security.configfile.panels.basic.StringPanel;
import com.excentis.security.configfile.tlvs.TLV_Unspecified;
import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.utils.CertUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import javax.swing.JPanel;

public class SAV_StaticPrefix
extends SubTLV
implements IStringTlv {
    public static final String typeInfo = "SAV Static Prefix Rule";
    public static final String fullTypeInfo = "SAV Static Prefix Rule".concat(" (2)");
    private byte[] itsAddress = null;
    private int itsPrefix = 0;

    public SAV_StaticPrefix(TLV parent, String ip_and_prefix) throws Exception {
        super(parent);
        this.setType(2);
        this.setStringValue(ip_and_prefix);
    }

    private void checkConstraints(String ip_and_prefix) throws Exception {
        Pattern p = Pattern.compile("/|-");
        String[] parts = p.split(ip_and_prefix, 2);
        int prefix = new Integer(parts[1]);
        if (prefix < 0 || prefix > 128) {
            throw new Exception("prefix must be between 0 and 128, use ipv4/prefix or ipv6/prefix");
        }
    }

    @Override
    public void setStringValue(String ip_and_prefix) throws Exception {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(ip_and_prefix);
        }
        Pattern p = Pattern.compile("/|-");
        String[] parts = p.split(ip_and_prefix, 2);
        byte[] addr = null;
        int prefix = 0;
        try {
            addr = Inet4Address.getByName(parts[0]).getAddress();
            prefix = new Integer(parts[1]);
        }
        catch (UnknownHostException e1) {
            try {
                addr = Inet6Address.getByName(parts[0]).getAddress();
                prefix = new Integer(parts[1]);
            }
            catch (UnknownHostException e2) {
                throw new Exception("invalid ip, use ipv4/prefix or ipv6/prefix");
            }
        }
        this.itsAddress = addr;
        this.itsPrefix = prefix;
        this.setData(CertUtils.appendAt(new TLV_Unspecified(1, this.itsAddress).getEncoded(), new TLV_Unspecified(2, new byte[]{(byte)this.itsPrefix}).getEncoded()));
    }

    @Override
    public String getStringValue() {
        if (this.itsAddress.length == 4) {
            try {
                return Inet4Address.getByAddress(this.itsAddress).getHostAddress() + "/" + this.itsPrefix;
            }
            catch (UnknownHostException e) {
                Binary2Plaintext b2p = new Binary2Plaintext(this.getValue());
                return "" + b2p.getHexRepresentation();
            }
        }
        if (this.itsAddress.length == 16) {
            try {
                return Inet6Address.getByAddress(this.itsAddress).getHostAddress() + "/" + this.itsPrefix;
            }
            catch (UnknownHostException e) {
                Binary2Plaintext b2p = new Binary2Plaintext(this.getValue());
                return "" + b2p.getHexRepresentation();
            }
        }
        Binary2Plaintext b2p = new Binary2Plaintext(this.getValue());
        return "" + b2p.getHexRepresentation();
    }

    @Override
    public String getShowValue() {
        return this.getStringValue();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new StringPanel(this, "SAV Static Prefix (ip/prefix): ");
    }
}

