/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types;

import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class SingleDownChannel_Timeout
extends SubTLV
implements INumberTlv {
    public static final String typeInfo = "Single Downstream Channel Timeout";
    public static final String fullTypeInfo = "Single Downstream Channel Timeout".concat(" (1)");
    private int itsTimeout = 0;

    public SingleDownChannel_Timeout(TLV parent, int timeout) throws Exception {
        super(parent);
        this.setType(1);
        this.setNumber(timeout);
    }

    private void checkConstraints(int timeout) throws InvalidNumberException {
        if (timeout < 0) {
            throw new InvalidNumberException(this, 0, 65535);
        }
        if (timeout > 65535) {
            throw new InvalidNumberException(this, 0, 65535);
        }
    }

    @Override
    public void setNumber(int timeout) throws InvalidNumberException, InvalidLengthException {
        this.checkConstraints(timeout);
        this.setData(this.encodeInt2(timeout));
        this.itsTimeout = timeout;
    }

    @Override
    public int getNumber() {
        return this.itsTimeout;
    }

    @Override
    public String getShowValue() {
        return "" + this.itsTimeout;
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Timeout:");
    }
}

