/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub2types.docsis30;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.docsis30.InvalidTransportAddressException;
import com.excentis.security.configfile.panels.sub2panels.docsis30.TransportAddress_MaskPanel;
import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.tools.Plaintext2Binary;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import javax.swing.JPanel;

public class TransportAddress_Mask
extends SubTLV {
    private byte[] itsAddress = null;
    public static final String typeInfo = "SNMPv1v2c Transport Address Mask";
    public static final String fullTypeInfo = "SNMPv1v2c Transport Address Mask".concat(" (2)");

    public TransportAddress_Mask(TLV parent, byte[] value) throws Exception {
        super(parent);
        this.setType(2);
        this.setAddress(value);
    }

    private void checkConstraints(byte[] value) throws InvalidTransportAddressException {
        if (value.length != 6 && value.length != 18) {
            throw new InvalidTransportAddressException();
        }
    }

    public void setAddress(byte[] value) throws InvalidTransportAddressException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(value);
        }
        this.setData(value);
        this.itsAddress = (byte[])value.clone();
    }

    public String getAddress() {
        return this.getShowValue();
    }

    @Override
    public String getShowValue() {
        if (this.itsAddress.length == 6) {
            String ip = new Binary2Plaintext(this.itsAddress).getHexRepresentation().substring(0, 8);
            String port = new Binary2Plaintext(this.itsAddress).getHexRepresentation().substring(8, 12);
            try {
                return Inet4Address.getByAddress(new Plaintext2Binary(ip).getBytes()).getHostAddress() + "/" + new BigInteger(new Plaintext2Binary(port).getBytes()).intValue();
            }
            catch (UnknownHostException e) {
                Binary2Plaintext b2p = new Binary2Plaintext(this.itsAddress);
                return "" + b2p.getHexRepresentation();
            }
        }
        if (this.itsAddress.length == 18) {
            String ip = new Binary2Plaintext(this.itsAddress).getHexRepresentation().substring(0, 32);
            String port = new Binary2Plaintext(this.itsAddress).getHexRepresentation().substring(32, 36);
            try {
                return Inet6Address.getByAddress(new Plaintext2Binary(ip).getBytes()).getHostAddress() + "/" + new BigInteger(new Plaintext2Binary(port).getBytes()).intValue();
            }
            catch (UnknownHostException e) {
                Binary2Plaintext b2p = new Binary2Plaintext(this.itsAddress);
                return "" + b2p.getHexRepresentation();
            }
        }
        Binary2Plaintext b2p = new Binary2Plaintext(this.itsAddress);
        return "" + b2p.getHexRepresentation();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new TransportAddress_MaskPanel(this);
    }
}

