/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub3types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.interfaces.IMaskTlv;
import com.excentis.security.configfile.panels.basic.MaskPanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class BGP_RouteDistinguisher
extends SubTLV
implements IMaskTlv {
    public static final String typeInfo = "Route Distinguisher";
    public static final String fullTypeInfo = "Route Distinguisher".concat(" (2)");

    public BGP_RouteDistinguisher(TLV parent, byte[] mask) throws Exception {
        super(parent);
        this.setType(2);
        this.setMask(mask);
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new MaskPanel(this, "Route Distinguisher (8-byte encoded): ");
    }

    private void checkConstraints(byte[] mask) throws Exception {
        if (!ConfigFile.getCheatMode() && mask.length != 8) {
            throw new Exception("Route Distinguisher must be 8 bytes long");
        }
    }

    @Override
    public String getShowValue() {
        return this.getMask();
    }

    @Override
    public String getMask() {
        return new Binary2Plaintext(this.getValue()).getHexRepresentation();
    }

    @Override
    public void setMask(byte[] mask) throws Exception {
        this.checkConstraints(mask);
        this.setData(mask);
    }
}

