/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub3types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.interfaces.IMaskTlv;
import com.excentis.security.configfile.panels.basic.MaskPanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class BGP_RouteTargetExport
extends SubTLV
implements IMaskTlv {
    public static final String typeInfo = "Route Target (Export)";
    public static final String fullTypeInfo = "Route Target (Export)".concat(" (4)");

    public BGP_RouteTargetExport(TLV parent, byte[] mask) throws Exception {
        super(parent);
        this.setType(4);
        this.setMask(mask);
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new MaskPanel(this, "Route Target (Export) (multiple of 8-byte encoded): ");
    }

    private void checkConstraints(byte[] mask) throws Exception {
        if (!ConfigFile.getCheatMode() && mask.length % 8 != 0) {
            throw new Exception("Route Target must be a multiple of 8 bytes long");
        }
    }

    @Override
    public String getShowValue() {
        return this.getMask();
    }

    @Override
    public String getMask() {
        return new Binary2Plaintext(this.getValue()).getHexRepresentation();
    }

    @Override
    public void setMask(byte[] mask) throws Exception {
        this.checkConstraints(mask);
        this.setData(mask);
    }
}

