/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub3types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.interfaces.IMaskTlv;
import com.excentis.security.configfile.panels.basic.MaskPanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class L2VPN_NSI_Ieee8021ad
extends SubTLV
implements IMaskTlv {
    public static final String typeInfo = "Service Multiplexing Value IEEE 802.1ad";
    public static final String fullTypeInfo = "Service Multiplexing Value IEEE 802.1ad".concat(" (3)");

    public L2VPN_NSI_Ieee8021ad(TLV parent, byte[] vlan) throws Exception {
        super(parent);
        this.setType(3);
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(vlan);
        }
        this.setMask(vlan);
    }

    public void checkConstraints(byte[] vlan) throws Exception {
        if (vlan.length != 4) {
            throw new Exception("IEEE 802.1ad tag must be 4 bytes long. (got " + vlan.length + ")");
        }
    }

    @Override
    public void setMask(byte[] vlan) throws InvalidLengthException {
        this.setData(vlan);
    }

    @Override
    public String getMask() {
        return new Binary2Plaintext(this.getValue()).getHexRepresentation();
    }

    @Override
    public String getShowValue() {
        return this.getMask();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new MaskPanel(this, "IEEE 802.1ad Tag (4-byte hex): ");
    }
}

