/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub3types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.interfaces.IMaskTlv;
import com.excentis.security.configfile.panels.basic.MaskPanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class L2VPN_NSI_Ieee8021ad_Stpid
extends SubTLV
implements IMaskTlv {
    public static final String typeInfo = "Service Multiplexing Value IEEE 802.1ad S-TPID";
    public static final String fullTypeInfo = "Service Multiplexing Value IEEE 802.1ad S-TPID".concat(" (8)");

    public L2VPN_NSI_Ieee8021ad_Stpid(TLV parent, byte[] vlan) throws Exception {
        super(parent);
        this.setType(8);
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(vlan);
        }
        this.setMask(vlan);
    }

    public void checkConstraints(byte[] vlan) throws Exception {
        if (vlan.length != 2) {
            throw new Exception("IEEE 802.1ad S-TPID must be 2 bytes long. (got " + vlan.length + ")");
        }
    }

    @Override
    public void setMask(byte[] vlan) throws InvalidLengthException {
        this.setData(vlan);
    }

    @Override
    public String getMask() {
        return new Binary2Plaintext(this.getValue()).getHexRepresentation();
    }

    @Override
    public String getShowValue() {
        return this.getMask();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new MaskPanel(this, "IEEE 802.1ad S-TPID (2-byte hex): ");
    }
}

