/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub3types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.interfaces.IMaskTlv;
import com.excentis.security.configfile.panels.basic.MaskPanel;
import com.excentis.security.tools.Binary2Plaintext;
import javax.swing.JPanel;

public class MESP_BP_CM_ColorIdentificationFieldValue
extends SubTLV
implements IMaskTlv {
    public static final String typeInfo = "MESP-BP-CM Color Identification Field Value";
    public static final String fullTypeInfo = "MESP-BP-CM Color Identification Field Value".concat(" (2)");

    public MESP_BP_CM_ColorIdentificationFieldValue(TLV parent, byte[] vlan) throws Exception {
        super(parent);
        this.setType(2);
        this.setMask(vlan);
    }

    public void checkConstraints(byte[] value) throws InvalidLengthException {
        if (value.length != 1) {
            throw new InvalidLengthException("MESP-BP-CM Color Identification Field Value must be 1 byte long. (got " + value.length + ")");
        }
    }

    @Override
    public void setMask(byte[] vlan) throws InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(vlan);
        }
        this.setData(vlan);
    }

    @Override
    public String getMask() {
        return new Binary2Plaintext(this.getValue()).getHexRepresentation();
    }

    @Override
    public String getShowValue() {
        return this.getMask();
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new MaskPanel(this, "MESP-BP-CM Color Identification Field Value (1-byte hex): ");
    }
}

