/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.configfile.tlvs.tlvsub4types;

import com.excentis.security.configfile.ConfigFile;
import com.excentis.security.configfile.SubTLV;
import com.excentis.security.configfile.TLV;
import com.excentis.security.configfile.exceptions.InvalidLengthException;
import com.excentis.security.configfile.exceptions.InvalidNumberException;
import com.excentis.security.configfile.interfaces.INumberTlv;
import com.excentis.security.configfile.panels.basic.NumberPanel;
import javax.swing.JPanel;

public class RemoteMEP_Id
extends SubTLV
implements INumberTlv {
    private int itsId;
    public static final String typeInfo = "Remote MEP Id";
    public static final String fullTypeInfo = "Remote MEP Id".concat(" (4)");

    public RemoteMEP_Id(TLV parent, int id) throws Exception {
        super(parent);
        this.setType(4);
        this.setNumber(id);
    }

    @Override
    public String getShowValue() {
        return "" + this.getNumber();
    }

    private void checkConstraints(int type) throws InvalidNumberException {
        if (type < 1 || type > 8191) {
            throw new InvalidNumberException(this, 1, 8191);
        }
    }

    @Override
    public String getTypeInfo() {
        return typeInfo;
    }

    @Override
    public JPanel showGUI() {
        return new NumberPanel(this, "Remote MEP ID:");
    }

    @Override
    public int getNumber() {
        return this.itsId;
    }

    @Override
    public void setNumber(int number) throws InvalidNumberException, InvalidLengthException {
        if (!ConfigFile.getCheatMode()) {
            this.checkConstraints(number);
        }
        this.itsId = number;
        this.setData(this.encodeInt2(this.itsId));
    }
}

