/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.tcl;

import com.excentis.security.tools.Binary2Plaintext;
import com.excentis.security.tools.Plaintext2Binary;
import com.excentis.security.utils.CertUtils;
import com.excentis.security.utils.DafKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.util.BitSet;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class F {
    public static String generateKeyingMaterial(String key, String seed, int minBytes) throws Exception {
        byte[] dig = new byte[]{};
        int bytesToGo = minBytes;
        Mac mac = null;
        try {
            mac = Mac.getInstance("HMAC-SHA1");
        }
        catch (Exception e) {
            mac = Mac.getInstance("HmacSHA1");
        }
        mac.init(new DafKey(new Plaintext2Binary(key).getBytes()));
        mac.update(seed.getBytes());
        byte[] A = mac.doFinal();
        while (bytesToGo > 0) {
            mac.update(CertUtils.appendAt(A, seed.getBytes()));
            dig = CertUtils.appendAt(dig, mac.doFinal());
            mac.update(A);
            A = mac.doFinal();
            bytesToGo -= 20;
        }
        return new Binary2Plaintext(dig).getHexRepresentation();
    }

    private static byte[] xor(byte[] one, byte[] two) throws Exception {
        if (one.length != two.length) {
            throw new Exception("can't xor two bytearrays that haven't got the same length, l1 = " + one.length + ", l2 = " + two.length);
        }
        byte[] res = new byte[one.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)(one[i] ^ two[i]);
        }
        return res;
    }

    public static String generateKeyingMaterialwithAES(String key, String seed, int minBytes) throws Exception {
        int ch;
        if (minBytes > 4080) {
            throw new Exception("can generate that amount of bytes, limited to 4080");
        }
        byte[] keyb = new Plaintext2Binary(key).getBytes();
        byte[] derivedkey = new byte[16];
        for (int i = 0; i < keyb.length; i += 16) {
            byte[] temp = new byte[16];
            System.arraycopy(keyb, i, temp, 0, Math.min(16, keyb.length - i));
            derivedkey = F.xor(derivedkey, temp);
        }
        byte[] seedb = new Plaintext2Binary(seed).getBytes();
        byte[] derivedseed = new byte[16];
        System.arraycopy(seedb, 0, derivedseed, 0, Math.min(16, seedb.length));
        boolean blocknum = true;
        byte[] blocknumbyte = new byte[16];
        blocknumbyte[15] = (byte)(blocknum ? 1 : 0);
        byte[] iv = F.xor(derivedseed, blocknumbyte);
        SecretKeySpec keyspec = new SecretKeySpec(derivedkey, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        cipher.init(1, (Key)keyspec, ivSpec);
        ByteArrayInputStream bIn = new ByteArrayInputStream(new byte[minBytes]);
        CipherInputStream cIn = new CipherInputStream(bIn, cipher);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        while ((ch = cIn.read()) >= 0) {
            bOut.write(ch);
        }
        byte[] cipherText = bOut.toByteArray();
        cIn.close();
        return new Binary2Plaintext(cipherText).getHexRepresentation();
    }

    public static void main(String[] args) {
        try {
            int ch;
            String keyaes = F.generateKeyingMaterialwithAES("53616520657274232034373839", new Binary2Plaintext("CMTS-EMIC".getBytes()).getHexRepresentation(), 32);
            System.out.println("key: " + new String(new Plaintext2Binary("53616520657274232034373839").getBytes()));
            System.out.println("keybytes: " + keyaes);
            BitSet bs = new BitSet();
            bs.set(4);
            bs.set(9);
            SecretKeySpec key = new SecretKeySpec(new Plaintext2Binary("53616520657274232034373839000000").getBytes(), "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(new Plaintext2Binary("434D54532D454D494300000000000001").getBytes());
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            System.out.println("input : " + new String(new byte[32]));
            Cipher cipher2 = Cipher.getInstance("AES/CTR/NoPadding");
            cipher.init(1, (Key)key, ivSpec);
            cipher2.init(1, (Key)key, ivSpec);
            ByteArrayInputStream bIn = new ByteArrayInputStream(new byte[32]);
            CipherInputStream cIn = new CipherInputStream(bIn, cipher);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            while ((ch = cIn.read()) >= 0) {
                bOut.write(ch);
            }
            cIn.close();
            byte[] cipherText = bOut.toByteArray();
            System.out.println("cipher: " + new Binary2Plaintext(cipherText).getHexRepresentation());
            System.out.println("cipher2: " + new Binary2Plaintext(cipher2.doFinal(new byte[16])).getHexRepresentation());
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
        }
    }
}

