/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.tcl;

import java.math.BigInteger;

public class MMH {
    public static String MMH16(String message, String mmhkey, String padding) throws Exception {
        if (message.length() % 4 != 0) {
            throw new Exception("Message length must be even");
        }
        if (mmhkey.length() < message.length()) {
            throw new Exception("Key length must be at least Message length");
        }
        if (padding.length() != 4) {
            throw new Exception("Pad length must be 2");
        }
        int sum = 0;
        for (int i = 0; i < message.length(); i += 4) {
            int keyb = MMH.readString(mmhkey.substring(i, i + 4));
            int msgb = MMH.readString(message.substring(i, i + 4));
            sum += keyb * msgb;
        }
        if ((sum %= 65537) < 0) {
            sum += 65537;
        }
        int pa = MMH.readString(padding);
        return MMH.showInt(sum + pa);
    }

    public static String MMH_Mac(String message, String mmhkey, String padding) throws Exception {
        return MMH.MMH16(message, mmhkey, padding);
    }

    public static String MMH16_sigma_1(String message, String mmhkey) throws Exception {
        if (message.length() % 4 != 0) {
            throw new Exception("Message length must be even");
        }
        if (mmhkey.length() < message.length()) {
            throw new Exception("Key length must be at least Message length");
        }
        int sum = 0;
        for (int i = 0; i < message.length(); i += 4) {
            int keyb = MMH.readString(mmhkey.substring(i, i + 4));
            int msgb = MMH.readString(message.substring(i, i + 4));
            sum += keyb * msgb;
        }
        if ((sum %= 65537) < 0) {
            sum += 65537;
        }
        return MMH.showInt(sum);
    }

    public static String MMH_sigma_n(String message, String mmhkey, int n) throws Exception {
        if (message.length() % 4 != 0) {
            throw new Exception("Message length must be even");
        }
        if (mmhkey.length() < message.length() + 4 * (n - 1)) {
            throw new Exception("Key length must be at least Message length + 2*(n-1), n = " + n);
        }
        String res = "";
        for (int i = 0; i < n; ++i) {
            res = res.concat(MMH.MMH16_sigma_1(message, mmhkey.substring(4 * i, 4 * i + message.length())));
        }
        return res;
    }

    public static byte[] add(byte[] one, byte[] two, int exponent) throws Exception {
        int minlength;
        if (one.length != two.length) {
            throw new Exception("length of operandi is not equal, can't calculate MMH MAC");
        }
        BigInteger arg1 = new BigInteger(one);
        BigInteger arg2 = new BigInteger(two);
        BigInteger bigtwo = new BigInteger("2");
        BigInteger res = arg1.add(arg2).mod(bigtwo.pow(exponent));
        byte[] resarray = res.toByteArray();
        byte[] returnarray = (byte[])resarray.clone();
        int n = minlength = exponent % 8 == 0 ? exponent / 8 : exponent / 8 + 1;
        if (resarray.length < minlength) {
            returnarray = new byte[minlength];
            System.arraycopy(resarray, 0, returnarray, returnarray.length - resarray.length, resarray.length);
        } else if (resarray.length > minlength) {
            returnarray = new byte[minlength];
            System.arraycopy(resarray, resarray.length - returnarray.length, returnarray, 0, returnarray.length);
        }
        return returnarray;
    }

    private static String showInt(int i) {
        if (i < 0) {
            i += 65536;
        }
        String s = "";
        block8: for (int j = 0; j < 4; ++j) {
            int mod = i % 16;
            i /= 16;
            if (0 <= mod && mod <= 9) {
                s = "" + mod + s;
                continue;
            }
            switch (mod) {
                case 10: {
                    s = "A" + s;
                    continue block8;
                }
                case 11: {
                    s = "B" + s;
                    continue block8;
                }
                case 12: {
                    s = "C" + s;
                    continue block8;
                }
                case 13: {
                    s = "D" + s;
                    continue block8;
                }
                case 14: {
                    s = "E" + s;
                    continue block8;
                }
                case 15: {
                    s = "F" + s;
                }
            }
        }
        return s;
    }

    public static String returnMe(String s) {
        return s;
    }

    private static int readString(String hexv) {
        int total = 0;
        for (int i = 0; i < hexv.length(); ++i) {
            total += Character.digit(hexv.charAt(i), 16);
            total <<= 4;
        }
        if ((total >>= 4) >= 32768) {
            total -= 65536;
        }
        return total;
    }

    public static String MMH32(String message, String mmhkey, String padding) throws Exception {
        if (message.length() % 4 != 0) {
            throw new Exception("Message length must be even");
        }
        if (mmhkey.length() < message.length() + 4) {
            throw new Exception("Key length must be at least Message length + 2");
        }
        if (padding.length() != 8) {
            throw new Exception("Pad length must be 4");
        }
        String first = MMH.MMH16(message, mmhkey, padding.substring(0, 4));
        String last = MMH.MMH16(message, mmhkey.substring(4, mmhkey.length()), padding.substring(4, 8));
        return first + last;
    }

    public static void main(String[] args) {
        try {
            BigInteger bi = new BigInteger(new byte[]{-1, -1});
            System.out.println("bi: " + bi.intValue());
            System.out.println("mmh16: " + MMH.MMH16("4e6f77206973207468652074696d652e", "352ccf8495efd7dfb8f5740595eb98d6", "ae07"));
            System.out.println("mmh32: " + MMH.MMH32("4e6f77206973207468652074696d652e", "352ccf8495efd7dfb8f5740595eb98d6eb98", "bde1897b"));
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
        }
    }
}

