/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.utils;

import com.excentis.security.utils.PublicKeyNotFoundException;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class CertUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File f) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        FilterInputStream dis = null;
        byte[] bytestream = null;
        try {
            fis = new FileInputStream(f);
            dis = new DataInputStream(fis);
            bytestream = new byte[dis.available()];
            ((DataInputStream)dis).readFully(bytestream);
        }
        finally {
            if (dis != null) {
                dis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return bytestream;
    }

    public static int tbsLength(byte[] fullCert) throws PublicKeyNotFoundException {
        int totallength = fullCert.length;
        for (int i = 0; i < totallength - 4; ++i) {
            if (fullCert[i] != 2 || fullCert[i + 1] != 3 || fullCert[i + 2] != 1 || fullCert[i + 3] != 0 || fullCert[i + 4] != 1) continue;
            return i + 5;
        }
        throw new PublicKeyNotFoundException();
    }

    public static String getManufacturer(String subject) throws IOException {
        StringReader sr = new StringReader(subject);
        StreamTokenizer st = new StreamTokenizer(sr);
        st.wordChars(32, 32);
        st.wordChars(61, 61);
        st.wordChars(45, 45);
        st.wordChars(32, 32);
        st.wordChars(58, 58);
        st.wordChars(46, 46);
        st.wordChars(39, 39);
        st.wordChars(34, 34);
        st.quoteChar(44);
        while (st.nextToken() != -1) {
            String inner = st.sval.trim();
            StreamTokenizer st2 = new StreamTokenizer(new StringReader(inner));
            st2.wordChars(32, 32);
            st2.wordChars(45, 45);
            st2.wordChars(32, 32);
            st2.wordChars(58, 58);
            st2.wordChars(46, 46);
            st2.wordChars(39, 39);
            st2.quoteChar(61);
            st2.nextToken();
            if (st2.sval.trim().equals("O")) {
                st2.nextToken();
                return st2.sval.trim();
            }
            if (!st2.sval.trim().equals("OU") && !st2.sval.trim().equals("C") && !st2.sval.trim().equals("CN")) continue;
            st2.nextToken();
        }
        return null;
    }

    public static int countChar(String s, char c) {
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++result;
        }
        return result;
    }

    public static List<String> readIni(File f) throws FileNotFoundException, IOException {
        ArrayList<String> manufList = new ArrayList<String>();
        FileReader fr = new FileReader(f);
        StreamTokenizer st = new StreamTokenizer(fr);
        st.wordChars(95, 95);
        st.quoteChar(61);
        while (st.nextToken() != -1) {
            manufList.add(st.sval);
        }
        return manufList;
    }

    public static List<String> readMibs(File f) throws FileNotFoundException, IOException {
        ArrayList<String> manufList = new ArrayList<String>();
        FileReader fr = new FileReader(f);
        StreamTokenizer st = new StreamTokenizer(fr);
        st.wordChars(95, 95);
        st.wordChars(46, 46);
        st.wordChars(32, 32);
        st.quoteChar(9);
        while (st.nextToken() != -1) {
            manufList.add(st.sval);
        }
        return manufList;
    }

    public static List<String> readMibs(InputStream is) throws FileNotFoundException, IOException {
        ArrayList<String> manufList = new ArrayList<String>();
        InputStreamReader isr = new InputStreamReader(is);
        StreamTokenizer st = new StreamTokenizer(isr);
        st.wordChars(95, 95);
        st.wordChars(46, 46);
        st.wordChars(32, 32);
        st.quoteChar(9);
        while (st.nextToken() != -1) {
            manufList.add(st.sval);
        }
        return manufList;
    }

    public static String convertArea2CertInput(String input) {
        String output = "";
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\n') {
                if (i == input.length() - 1) continue;
                output = output + ',';
                continue;
            }
            output = output + input.charAt(i);
        }
        return output;
    }

    public static String[] parseX500(String name) throws IOException {
        String[] result = new String[CertUtils.countChar(name, ',') + 1];
        StringReader sr = new StringReader(name);
        StreamTokenizer st = new StreamTokenizer(sr);
        st.wordChars(61, 61);
        st.wordChars(45, 45);
        st.wordChars(32, 32);
        st.wordChars(58, 58);
        st.wordChars(46, 46);
        st.wordChars(39, 39);
        st.wordChars(34, 34);
        st.quoteChar(44);
        int i = 0;
        while (st.nextToken() != -1) {
            result[i++] = st.sval.trim();
        }
        return result;
    }

    public static String[] convertStringToStrings(String name) throws IOException {
        int len = name.lastIndexOf(10) == name.length() - 1 ? CertUtils.countChar(name, '\n') : CertUtils.countChar(name, '\n') + 1;
        String[] result = new String[len];
        int prev = 0;
        int enter = name.indexOf(10);
        if (enter == -1) {
            if (len != 1) {
                System.err.println("error: there should be more than one substring, but no \\n found!!");
            }
            result[0] = name;
            return result;
        }
        int i = 0;
        while (enter != -1) {
            String s = name.substring(prev, enter);
            prev = enter + 1;
            if ((enter = name.indexOf(10, prev)) == -1 && prev != 1 + name.length() && i + 1 != len) {
                enter = name.length();
            }
            result[i++] = s;
        }
        return result;
    }

    public static long[] parseDottedNumbers(String name) throws IOException {
        long[] result = new long[CertUtils.countChar(name, '.') + 1];
        StringReader sr = new StringReader(name);
        StreamTokenizer st = new StreamTokenizer(sr);
        st.quoteChar(46);
        int i = 0;
        while (st.nextToken() != -1) {
            result[i++] = (long)st.nval;
        }
        return result;
    }

    public static String[] convertLinesToStrings(String name1, String name2) {
        if (name1.equals("") || name2.equals("")) {
            if (name1.equals("")) {
                return new String[]{name2};
            }
            return new String[]{name1};
        }
        return new String[]{name1, name2};
    }

    public static String commaToEnter(String name) throws IOException {
        String[] fields = CertUtils.parseX500(name);
        String s = new String();
        for (int i = 0; i < fields.length; ++i) {
            s = s.concat(fields[i] + "\n");
        }
        return s;
    }

    public static byte[] appendAt(byte[] first, byte second) {
        int length = 0;
        if (first != null) {
            length = first.length;
        }
        byte[] result = new byte[length + 1];
        for (int i = 0; i < length; ++i) {
            result[i] = first[i];
        }
        result[length] = second;
        return result;
    }

    public static byte[] appendAt(byte[] first, byte[] second) {
        int i;
        if (first == null) {
            if (second == null) {
                return null;
            }
            return second;
        }
        if (second == null) {
            return first;
        }
        byte[] result = new byte[first.length + second.length];
        for (i = 0; i < first.length; ++i) {
            result[i] = first[i];
        }
        for (i = 0; i < second.length; ++i) {
            result[first.length + i] = second[i];
        }
        return result;
    }

    public static long[] appendAt(long[] first, long[] second) {
        int i;
        if (first == null) {
            if (second == null) {
                return null;
            }
            return second;
        }
        if (second == null) {
            return first;
        }
        long[] result = new long[first.length + second.length];
        for (i = 0; i < first.length; ++i) {
            result[i] = first[i];
        }
        for (i = 0; i < second.length; ++i) {
            result[first.length + i] = second[i];
        }
        return result;
    }

    public static byte[] encode(byte[] value, int type) {
        int len = value == null ? 0 : value.length;
        int totallen = 0;
        byte[] result = null;
        if (len < 128) {
            totallen = len + 2;
            result = new byte[totallen];
            result[0] = (byte)type;
            result[1] = (byte)len;
            for (int i = 0; i < len; ++i) {
                result[2 + i] = value[i];
            }
        } else if (len < 256) {
            totallen = len + 3;
            result = new byte[totallen];
            result[0] = (byte)type;
            result[1] = -127;
            result[2] = (byte)len;
            for (int i = 0; i < len; ++i) {
                result[3 + i] = value[i];
            }
        } else {
            totallen = len + 4;
            result = new byte[totallen];
            result[0] = (byte)type;
            result[1] = -126;
            result[2] = (byte)(len / 256);
            result[3] = (byte)(len % 256);
            for (int i = 0; i < len; ++i) {
                result[4 + i] = value[i];
            }
        }
        return result;
    }

    public static Byte stringToByte(String string) {
        int i = Integer.parseInt(string);
        Byte b = new Byte((byte)i);
        return b;
    }

    public static String byteToString(Byte b) {
        int integer = 0xFF & b;
        String string = Integer.toString(integer);
        return string;
    }
}

