/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.security.utils;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FileViewer
extends Frame
implements ActionListener {
    private static final long serialVersionUID = 1234567891L;
    String directory;
    JTextArea textarea;

    public FileViewer() {
        this((String)null, (String)null);
    }

    public FileViewer(String filename) {
        this(null, filename);
    }

    public FileViewer(String directory, String filename) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FileViewer.this.dispose();
            }
        });
        this.textarea = new JTextArea("", 24, 80);
        this.textarea.setFont(new Font("MonoSpaced", 0, 12));
        this.textarea.setEditable(false);
        this.textarea.setLineWrap(true);
        this.textarea.setWrapStyleWord(true);
        JScrollPane areaScrollPane = new JScrollPane(this.textarea);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        this.add("Center", areaScrollPane);
        Panel p = new Panel();
        p.setLayout(new FlowLayout(2, 10, 5));
        this.add((Component)p, "South");
        JButton close = new JButton("Close");
        close.addActionListener(this);
        close.setActionCommand("close");
        p.add(close);
        this.pack();
        if (directory == null) {
            File f;
            if (filename != null && (f = new File(filename)).isAbsolute()) {
                directory = f.getParent();
                filename = f.getName();
            } else {
                directory = System.getProperty("user.dir");
            }
        }
        this.directory = directory;
        this.setFile(directory, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(String directory, String filename) {
        if (filename == null || filename.length() == 0) {
            return;
        }
        FileInputStream in = null;
        Reader reader = null;
        try {
            int n;
            File f = new File(directory, filename);
            in = new FileInputStream(f);
            char[] buffer = new char[1024];
            reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            while ((n = reader.read(buffer)) != -1) {
                String s = new String(buffer, 0, n);
                this.textarea.append(s);
            }
            this.setTitle("FileViewer: " + filename);
            this.textarea.setCaretPosition(0);
        }
        catch (IOException e) {
            this.textarea.setText(e.getClass().getName() + ": " + e.getMessage());
            this.setTitle("FileViewer: " + filename + ": I/O Exception");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("close")) {
            this.dispose();
        }
    }
}

